/*
  standard library routines
  written by alexander yaworsky
  september '99
*/

#include <windows.h>


#include "stdlib.h"
#include "switches.h"


int  argc;
char* argv[256];

void InitArgs()
  {
    static char CmdLine[ 2048 ];
    char *cpa, *cpb;

    lstrcpy( CmdLine, GetCommandLine() );
    argc = 0;
    cpa = CmdLine;
    for(;;) {
      while( *cpa == ' ' || *cpa == '\t' ) cpa++;  // skip leading space
      if( *cpa == '\0' ) break;
      if( *cpa == '"' ) {             // param in quotes
        argv[ argc ] = ++cpa;
  again:
        cpb = Strchr( cpa, '"' );    // find trailing quote
        if( cpb == NULL ) {          //   not found - parse as usual
          argv[ argc ] = cpa - 1;
          while( *cpb != '\0' && *cpb != ' ' && *cpb != '\t' ) cpb++;
          if( *cpb != '\0' ) {
            *cpb = '\0';
            cpa = cpb + 1;
          }
          else
            cpa = cpb;  // end of command line
        }
        else {       // found - check second char
          if( *(cpb + 1) == '"' ) { // found - delete
            MoveMemory( cpb, cpb+1, lstrlen( cpb ) );
            cpa = cpb + 1;
            goto again;
          }
          // not found - end up argument
          *cpb = '\0';
          cpa = cpb + 1;
        }
      }
      else {  // regular param
        argv[ argc ] = cpa;
        while( *cpa != '\0' && *cpa != ' ' && *cpa != '\t' ) cpa++;
        if( *cpa != '\0' ) {
          *cpa = '\0'; cpa++;
        }
      }
      argc++;
    }
    argv[ argc ] = NULL;
  }

unsigned long Strtoul( char* s, char** endptr, int radix )
  {
    unsigned long v;
    char  ch, z;

    if( s == NULL ) return 0;
    if( radix != 0 && (radix < 2 || radix > 36) ) {
      if( endptr != NULL ) *endptr = s;
      return 0;
    }
    while( *s == ' ' ) s++;
    if( *s == '\0' ) {
      if( endptr != NULL ) *endptr = s;
      return 0;
    }
    if( radix == 0 ) {
      if( *s >= '1' && *s <= '9' ) radix = 10;
      else if( *s == '0' ) {
        if( *(s+1) == 'x' || *(s+1) == 'X' ) {
          radix = 16; s += 2;
        }
        else {
          radix = 8; s++;
        }
      }
      else {
        if( endptr != NULL ) *endptr = s;
        return 0;
      }
    }
    z = 1;  // leading zero mode indicator
    v = 0;
    for(;;) {
      ch = *s;
      if( ch == '\0' ) break;
      ch = (char) CharUpper( (LPTSTR) (((int) ch) & 255) );
      if( !((ch >= '0' && ch <= '9') || (ch >= 'A' && ch <= 'Z')) ) break;
      if( ch > '9' ) ch -= 'A' - '9' - 1;
      ch -= '0';
      if( ch >= radix ) break;
      if( z == 0 || ch != 0 ) {
        v = v * radix + (((unsigned long) ch) & 255);
        z = 0;
      }
      s++;
    }
    if( endptr != NULL ) *endptr = s;
    return v;
  }

char* Strchr( char* s, char c )
  {
    while( *s != c && *s != '\0' ) s++;
    if( *s == c ) return s;
    return NULL;
  }

char* Strrchr( char* s, char c )
  {
    char*  cp;

    cp = s + lstrlen( s );
    while( *cp != c && cp != s ) cp--;
    if( *cp == c ) return cp;
    return NULL;
  }

int Memcmp( void* a, void* b, int n )
  {
    int  i;

    for( i = 0; i < n; i++ )
      if( *((char*) a + i) != *((char*) b + i) ) return 1;
    return 0;
  }
